#include <stdio.h>
#include <string.h>
#include <math.h>

#include <algorithm>
#include <string>
#include <map>
#include <unordered_map>
#include <set>
#include <vector>
#include <queue>
#include <deque>
#include <iostream>

using namespace std;

struct vect
{
    int x, y, z;
};

int n;
vect v[100005];
int aib[100005];

int cmp (vect a, vect b)
{
    return a.z < b.z;
}

void update (int poz, int val)
{
    while (poz <= n)
    {
        aib[poz] = min (aib[poz], val);
        poz += poz & -poz;
    }
}

int query (int poz)
{
    int sol = aib[0];
    while (poz > 0)
    {
        sol = min (sol, aib[poz]);
        poz -= poz & -poz;
    }
    return sol;
}

int main ()
{
#ifdef local
    freopen ("e.in", "r", stdin);
    freopen ("e.out", "w", stdout);
#endif

    int tt;
    scanf ("%d", &tt);
    while (tt --)
    {
        memset (aib, 0x3f3f3f3f, sizeof (aib));
        scanf ("%d", &n);

        int i, x, y, z;

        for (i = 1; i <= n; i ++)
            scanf ("%d %d %d", &v[i].x, &v[i].y, &v[i].z);
        sort (v + 1, v + n + 1, cmp);

        int sol = n;
        for (i = 1; i <= n; i ++)
        {
            x = query (v[i].y - 1);
            if (x < v[i].x)
            {
                sol --;
            }
            update (v[i].y, v[i].x);
        }
        printf ("%d\n", sol);
    }
    return 0;
}
